#include "EFTrace.hpp"

namespace EFramework
{
	EFTrace::EFTrace()
	: mDebugMode( true ),
	  mStackPointer( 0 )
	{
		memset(mTraces, 0, sizeof(EFString)*TRACE_DEPTH);
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	void EFTrace::AddTrace(const EFString& function)
	{
		if(mDebugMode == true)
		{
			//==================================================
			// Ensure that our pointer is within bounds.
			//==================================================
			if(mStackPointer >= TRACE_DEPTH)
				mStackPointer = 0;

			//==================================================
			// Add the function at the appropriate point.
			//==================================================
			mTraces[ mStackPointer++ ] = function;
		}
	}

	EFString EFTrace::Trace(ulong TraceDepth)
	{
		//==================================================
		// Ensure that we can meet the trace depth.
		//==================================================
		if(TraceDepth >= TRACE_DEPTH)
			TraceDepth = (TRACE_DEPTH-1);
		if(mStackPointer < TraceDepth)
			return "NOT ENOUGH FUNCTION CALLS TO MEET TRACE DEPTH";
		if(!mDebugMode)
			return "DEBUG MODE IS OFF";

		//==================================================
		// Print a string tracing function calls.
		//==================================================
		EFString TraceString;

		for(ulong i = 0; i < TraceDepth; i++)
		{
			TraceString += mTraces[ i ];
			if((i+1) != TraceDepth)
				TraceString += " -> ";
		}

		return TraceString;
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	const void EFTrace::SetDebugMode(bool debugOn)
	{
		mDebugMode = debugOn;
	}

	bool EFTrace::GetDebugMode() const
	{
		return mDebugMode;
	}
} // Namespace EFramework